/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpEngine.DpeStats;
import ibm.nways.analysis.dpManager.Admin.DPETopology;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.LED;
import ibm.nways.analysis.dpManager.Admin.NetworkDisplay;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.NhmHelpRef;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCActionEvent;
import jclass.bwt.JCActionListener;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCButton;
import jclass.bwt.JCGridLayout;
import jclass.bwt.JCGroupBox;

public class DpeMonitor
extends Panel
implements ItemListener,
JCActionListener {
    private BorderLayout bLayout = new BorderLayout();
    private JCGridLayout gLayout = new JCGridLayout(4, 1, 5, 5);
    private JCAlignerLayout jcLayout = new JCAlignerLayout(2, 2, 2);
    private ColumnLayout cLayout = new ColumnLayout();
    private Applet appl;
    private DpAdminPanel adminPanel;
    private NetworkDisplay ND;
    private String ipAddress;
    private String savedIp;
    private String hostName;
    private DpeStats dpeStats;
    private Graphics graphics;
    private Dimension d;
    private Image offScreenImage;
    private Graphics offScreenGraphics;
    private Dimension offScreenSize;
    private Panel southPanel;
    Choice ipAddchoice;
    Hashtable dpeHashTable;
    private JCButton refresh;
    private JCButton dpeTopology;
    private JCButton helpButton;
    private Panel dpeListPanel;
    private Label dpeListLabel;
    private JCGroupBox gBox1;
    private LED led;
    private JCGroupBox gBox2;
    public List nodeList;
    public Vector nodesPolled;
    private JCGroupBox gBox5;
    private Label totalLabel;
    private Label totalValue;
    private Label availLabel;
    private Label availValue;
    private JCGroupBox gBox6;
    private Label ipLabel;
    private Label ipValue;
    private Label timeLabel;
    private Label timeValue;
    private JCGroupBox gBox7;
    private Label pollLabel;
    private Label pollValue;
    private Label mibVarLabel;
    private Label mibVarValue;
    private Label avgTimeLabel;
    private Label avgTimeValue;
    private JCGroupBox gBox8;
    private Label pduLabel;
    private Label pduValue;
    private Label mibRqstLabel;
    private Label mibRqstValue;
    private Label mibRcvdLabel;
    private Label mibRcvdValue;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String DPELIST_BOX_TITLE = adminRB.getString("s_DpeList");
    private static final String LED_BOX_TITLE = adminRB.getString("s_DpeUtil");
    private static final String NODESPOLLED_BOX_TITLE = adminRB.getString("s_NodesPolled");
    private static final String MEMORY_BOX_TITLE = adminRB.getString("s_Jvm");
    private static final String STATS_BOX_TITLE = adminRB.getString("s_Stats");
    private static final String DPECOUNTER_BOX_TITLE = adminRB.getString("s_DpeCounter");
    private static final String SNMPCOUNTER_BOX_TITLE = adminRB.getString("s_SnmpCounter");
    private static final String TOTAL_MEMORY_LABEL = adminRB.getString("s_Total");
    private static final String AVAIL_MEMORY_LABEL = adminRB.getString("s_Avail");
    private static final String IPADDRESS_LABEL = adminRB.getString("s_IP");
    private static final String DATE_TIME_LABEL = adminRB.getString("s_Date");
    private static final String POLL_LABEL = adminRB.getString("s_Polls");
    private static final String MIBVAR_LABEL = adminRB.getString("s_MibVar");
    private static final String AVGTOTAL_TIME_LABEL = adminRB.getString("s_AvgTime");
    private static final String PDU_SENT_LABEL = adminRB.getString("s_PDUs");
    private static final String MIB_REQUESTED_LABEL = adminRB.getString("s_MibRqst");
    private static final String MIB_RECEIVED_LABEL = adminRB.getString("s_MibRcvd");
    private static final String REFRESH_BUTTON_LABEL = adminRB.getString("s_Refresh");
    private static final String DPETOP_BUTTON_LABEL = adminRB.getString("s_DpeTop");
    private static final String HELP_BUTTON_LABEL = adminRB.getString("s_Help");
    private static final String NO_NODES_POLLED_MSG = adminRB.getString("s_NoNodes");
    private static final String INITIAL_CHOICEBOX_STR = "                                             ";

    public DpeMonitor(NetworkDisplay networkDisplay, Applet applet) {
        this.appl = applet;
        this.ND = networkDisplay;
        this.adminPanel = this.ND.getDpAdminRef();
        this.bLayout = new BorderLayout();
        this.setLayout(this.bLayout);
        this.dpeListPanel = new Panel();
        this.dpeListLabel = new Label(DPELIST_BOX_TITLE);
        this.ipAddchoice = new Choice();
        this.ipAddchoice.addItemListener(this);
        this.dpeListPanel.add(this.dpeListLabel);
        this.dpeListPanel.add(this.ipAddchoice);
        this.add("North", this.dpeListPanel);
        Panel panel = new Panel();
        panel.setLayout(new JCGridLayout(3, 2, 10, 5));
        this.gBox1 = new JCGroupBox(LED_BOX_TITLE);
        this.led = new LED(this);
        this.gBox1.setLayout(new FlowLayout(1));
        this.gBox1.add(this.led);
        this.gBox2 = new JCGroupBox(NODESPOLLED_BOX_TITLE);
        this.gBox2.setLayout(new FlowLayout(1));
        this.nodeList = new List(7);
        this.gBox2.add(this.nodeList);
        this.gBox5 = new JCGroupBox(MEMORY_BOX_TITLE);
        this.gBox5.setLayout(this.jcLayout);
        this.totalLabel = new Label(TOTAL_MEMORY_LABEL);
        this.totalValue = new Label("      ");
        this.availLabel = new Label(AVAIL_MEMORY_LABEL);
        this.availValue = new Label("      ");
        this.gBox5.add(this.totalLabel);
        this.gBox5.add(this.totalValue);
        this.gBox5.add(this.availLabel);
        this.gBox5.add(this.availValue);
        this.gBox6 = new JCGroupBox(STATS_BOX_TITLE);
        this.gBox6.setLayout(this.jcLayout);
        this.ipLabel = new Label(IPADDRESS_LABEL);
        this.ipValue = new Label("                    ");
        this.timeLabel = new Label(DATE_TIME_LABEL);
        this.timeValue = new Label("                                                     ");
        this.gBox6.add(this.ipLabel);
        this.gBox6.add(this.ipValue);
        this.gBox6.add(this.timeLabel);
        this.gBox6.add(this.timeValue);
        this.gBox7 = new JCGroupBox(DPECOUNTER_BOX_TITLE);
        this.gBox7.setLayout(this.jcLayout);
        this.pollLabel = new Label(POLL_LABEL);
        this.pollValue = new Label("               ");
        this.mibVarLabel = new Label(MIBVAR_LABEL);
        this.mibVarValue = new Label("               ");
        this.avgTimeLabel = new Label(AVGTOTAL_TIME_LABEL);
        this.avgTimeValue = new Label("               ");
        this.gBox7.add(this.pollLabel);
        this.gBox7.add(this.pollValue);
        this.gBox7.add(this.mibVarLabel);
        this.gBox7.add(this.mibVarValue);
        this.gBox7.add(this.avgTimeLabel);
        this.gBox7.add(this.avgTimeValue);
        this.gBox8 = new JCGroupBox(SNMPCOUNTER_BOX_TITLE);
        this.gBox8.setLayout(this.jcLayout);
        this.pduLabel = new Label(PDU_SENT_LABEL);
        this.pduValue = new Label("               ");
        this.mibRqstLabel = new Label(MIB_REQUESTED_LABEL);
        this.mibRqstValue = new Label("               ");
        this.mibRcvdLabel = new Label(MIB_RECEIVED_LABEL);
        this.mibRcvdValue = new Label("               ");
        this.gBox8.add(this.pduLabel);
        this.gBox8.add(this.pduValue);
        this.gBox8.add(this.mibRqstLabel);
        this.gBox8.add(this.mibRqstValue);
        this.gBox8.add(this.mibRcvdLabel);
        this.gBox8.add(this.mibRcvdValue);
        panel.add(this.gBox1);
        panel.add(this.gBox2);
        panel.add(this.gBox5);
        panel.add(this.gBox6);
        panel.add(this.gBox7);
        panel.add(this.gBox8);
        Panel panel2 = new Panel();
        panel2.add(panel);
        this.southPanel = new Panel();
        this.refresh = new JCButton(REFRESH_BUTTON_LABEL);
        this.refresh.addActionListener(this);
        this.dpeTopology = new JCButton(DPETOP_BUTTON_LABEL);
        this.dpeTopology.addActionListener(this);
        this.helpButton = new JCButton(HELP_BUTTON_LABEL);
        this.helpButton.addActionListener(this);
        this.southPanel.add(this.refresh);
        this.southPanel.add(this.dpeTopology);
        this.southPanel.add(this.helpButton);
        this.add("Center", panel2);
        this.add("South", this.southPanel);
        this.updateHashTable();
    }

    public NetworkDisplay getNDRef() {
        return this.ND;
    }

    public String getHostName() {
        return this.ipAddchoice.getSelectedItem();
    }

    public void setSavedIp(String string) {
        this.savedIp = string;
        this.ipAddchoice.select(this.savedIp);
    }

    public void updateHashTable() {
        this.ND.updateDPEInformation();
        this.dpeHashTable = this.ND.getDpeStatsTable();
        if (this.dpeHashTable.size() == 0) {
            this.ipAddress = "";
            this.hostName = INITIAL_CHOICEBOX_STR;
            this.ipAddchoice.add(this.hostName);
            return;
        }
        this.ipAddchoice.removeAll();
        Enumeration enumeration = this.dpeHashTable.keys();
        while (enumeration.hasMoreElements()) {
            this.ipAddress = (String)enumeration.nextElement();
            this.hostName = this.ND.giveIpGetHostName(this.ipAddress);
            this.ipAddchoice.add(this.hostName);
        }
    }

    public void updateNodeInfo(String string) {
        String string2 = null;
        this.nodeList.removeAll();
        try {
            this.nodesPolled = this.adminPanel.getAdminInterface().getNodesPolled(string);
        }
        catch (Exception exception) {
            System.out.println("Exception while retrieving nodes polled from the server.");
            exception.printStackTrace();
        }
        if (this.nodesPolled.size() == 0) {
            this.nodeList.addItem(NO_NODES_POLLED_MSG);
            return;
        }
        Enumeration enumeration = this.nodesPolled.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            this.nodeList.addItem(string2);
        }
    }

    public void setNodeList(String string) {
        this.updateNodeInfo(string);
    }

    public void eventHandler(String string) {
        String string2 = null;
        string2 = string;
        if (string2.equals(INITIAL_CHOICEBOX_STR)) {
            this.led.repaint();
            this.totalValue.setText("");
            this.availValue.setText("");
            this.ipValue.setText("");
            this.timeValue.setText("");
            this.pollValue.setText("");
            this.mibVarValue.setText("");
            this.avgTimeValue.setText("");
            this.pduValue.setText("");
            this.mibRqstValue.setText("");
            this.mibRcvdValue.setText("");
        }
        this.ipAddress = this.ND.giveHostNameGetIp(string2);
        this.dpeStats = (DpeStats)this.dpeHashTable.get(this.ipAddress);
        if (this.dpeStats != null) {
            this.led.repaint();
            long l = this.dpeStats.totalMemory;
            long l2 = this.dpeStats.freeMemory;
            Long l3 = new Long(l /= 1024L);
            Long l4 = new Long(l2 /= 1024L);
            this.totalValue.setText(Long.toString(l));
            this.availValue.setText(Long.toString(l2));
            this.ipValue.setText(this.dpeStats.hostname);
            this.timeValue.setText(new Date(this.dpeStats.date).toString());
            this.pollValue.setText(String.valueOf(this.dpeStats.counters.pollsSent));
            this.mibVarValue.setText(String.valueOf(this.dpeStats.counters.variablesSent));
            this.avgTimeValue.setText(String.valueOf(this.dpeStats.counters.averageTotalTime));
            this.pduValue.setText(String.valueOf(this.dpeStats.totalPDUs));
            this.mibRqstValue.setText(String.valueOf(this.dpeStats.totalSentVars));
            this.mibRcvdValue.setText(String.valueOf(this.dpeStats.totalReceivedVars));
        }
        this.updateNodeInfo(string2);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.ipAddchoice && itemEvent.getID() == 701) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    this.eventHandler(this.ipAddchoice.getSelectedItem());
                    return;
                }
                default: {
                    System.out.println("Unknown item event: " + itemEvent);
                }
                case 2: 
            }
        }
    }

    public void updateDpeMon() {
        this.savedIp = this.ipAddchoice.getSelectedItem();
        this.ipAddchoice.removeAll();
        this.updateHashTable();
        this.ipAddchoice.select(this.savedIp);
        this.eventHandler(this.savedIp);
    }

    public void actionPerformed(JCActionEvent jCActionEvent) {
        if (jCActionEvent.getSource() == this.refresh) {
            this.updateDpeMon();
            DPETopology dPETopology = this.ND.getDpeTopRef();
            dPETopology.updateDpeTop();
            return;
        }
        if (jCActionEvent.getSource() == this.dpeTopology) {
            this.ND.showDpeTop();
            return;
        }
        if (jCActionEvent.getSource() == this.helpButton) {
            NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
            if (this.appl instanceof BrowserApplet) {
                BrowserApplet browserApplet = (BrowserApplet)this.appl;
                browserApplet.showHelp(nhmHelpRef);
                return;
            }
            this.appl.getAppletContext().showDocument(nhmHelpRef.getURL(this.appl));
        }
    }

    public void update(Graphics graphics) {
        this.d = this.getSize();
        if (this.offScreenImage == null || this.d.width != this.offScreenSize.width || this.d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(this.d.width, this.d.height);
            this.offScreenSize = this.d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        graphics.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics graphics) {
        this.graphics = graphics;
        this.d = this.getSize();
        if (this.ipAddress != "") {
            this.led.paint(this.graphics);
        }
    }
}

